(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14401,        378]*)
(*NotebookOutlinePosition[     15235,        404]*)
(*  CellTagsIndexPosition[     15191,        400]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["The program", "Subtitle"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(myDir =. \)], "Input"],

Cell[BoxData[
    \(\(Options[
          MakeGlossary] = {HomeFolder \[Rule] 
            ToFileName[\(NotebookInformation[
                  EvaluationNotebook[]]\)\[LeftDoubleBracket]1, 2, 
                1\[RightDoubleBracket]], NumberingStart \[Rule] Automatic, 
          NumberingStep \[Rule] Automatic};\)\)], "Input"],

Cell[BoxData[
    \(\(addFolderToItem[folder_String, n0_Integer, 
          stp_Integer, \n\ \ \ \ \ \ \ \ \ \ itemsList : {{_String, \
___String} .. }, {n_Integer}]\  := \ \n\ \ \ \ \ \ \ \ Map[{folder, \ \n\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ StringJoin[
                StringTake[\ 
                  ToString[
                    NumberForm[n0 + stp*\((n - 1)\), \ 2, \ 
                      NumberPadding\  -> \ {"\<0\>", \ "\<\>"}]], \ \(-2\)], \
"\<)\>", #[\([1]\)]], Sequence\  @@ \ Rest[#]} &, itemsList];\)\)], "Input"],

Cell[BoxData[
    \(\(addFolder[n0_Integer, 
          stp_Integer] := {{b_String, {c : {__String} .. }} \[RuleDelayed] 
            Sequence @@ 
              Flatten[MapIndexed[addFolderToItem[b, n0, stp, ##] &, 
                  Split[{c}, First[#1] === First[#2] &]], 
                1], \[IndentingNewLine]{b_String, 
              c : {__String} .. } \[RuleDelayed] 
            Sequence @@ 
              Flatten[MapIndexed[addFolderToItem[b, n0, stp, ##] &, 
                  Split[{c}, First[#1] === First[#2] &]], 1]};\)\)], "Input"],

Cell[BoxData[
    \(\(addFolder[Automatic, 
          stp_] := {{b_String, {c : {__String} .. }} \[RuleDelayed] 
            Sequence @@ 
              Flatten[MapIndexed[addFolderToItem[b, stp, stp, ##] &, 
                  Split[{c}, First[#1] === First[#2] &]], 
                1], \[IndentingNewLine]{b_String, 
              c : {__String} .. } \[RuleDelayed] 
            Sequence @@ 
              Flatten[MapIndexed[addFolderToItem[b, stp, stp, ##] &, 
                  Split[{c}, First[#1] === First[#2] &]], 1]};\)\)], "Input"],

Cell[BoxData[
    \(\(addFolder[n0_Integer, 
          Automatic] := {{b_String, {c : {__String} .. }} \[RuleDelayed] 
            Module[{spl, stp}, \[IndentingNewLine]spl = 
                Split[{c}, 
                  First[#1] === First[#2] &]; \[IndentingNewLine]stp = 
                Floor[\((100 - n0)\)/\((Length[spl])\)]; 
              Sequence @@ 
                Flatten[MapIndexed[addFolderToItem[b, n0, stp, ##] &, spl], 
                  1]], \[IndentingNewLine]{b_String, 
              c : {__String} .. } \[RuleDelayed] 
            Module[{spl, stp}, \[IndentingNewLine]spl = 
                Split[{c}, 
                  First[#1] === First[#2] &]; \[IndentingNewLine]stp = 
                Floor[\((100 - n0)\)/\((Length[spl])\)]; 
              Sequence @@ 
                Flatten[MapIndexed[addFolderToItem[b, n0, stp, ##] &, spl], 
                  1]]};\)\)], "Input"],

Cell[BoxData[
    \(\(addFolder[Automatic, 
          Automatic] := {{b_String, {c : {__String} .. }} \[RuleDelayed] 
            Module[{spl, n0, stp}, \[IndentingNewLine]spl = 
                Split[{c}, 
                  First[#1] === First[#2] &]; \[IndentingNewLine]n0 = 
                Floor[100/\((Length[spl] + 1)\)]; \[IndentingNewLine]stp = 
                n0; Sequence @@ 
                Flatten[MapIndexed[addFolderToItem[b, n0, stp, ##] &, spl], 
                  1]], \[IndentingNewLine]{b_String, 
              c : {__String} .. } \[RuleDelayed] 
            Module[{spl, n0, stp}, \[IndentingNewLine]spl = 
                Split[{c}, 
                  First[#1] === First[#2] &]; \[IndentingNewLine]n0 = 
                Floor[100/\((Length[spl] + 1)\)]; \[IndentingNewLine]stp = 
                n0; Sequence @@ 
                Flatten[MapIndexed[addFolderToItem[b, n0, stp, ##] &, spl], 
                  1]]};\)\)], "Input"],

Cell[BoxData[
    \(\(createFile[{dir__String, 
            menuContent_String}] := \[IndentingNewLine]Module[{listaNomi}, \
\[IndentingNewLine]listaNomi = 
            Map[StringDrop[#, \(-1\)] &, 
              Map[ToFileName, 
                ReplaceList[{dir}, {a__, 
                      b__} \[RuleDelayed] {a}]]]; \ \
\[IndentingNewLine]SetDirectory[{dir}[\([1]\)]]; \[IndentingNewLine]Map[
            If[\(! MemberQ[DirectoryStack[], #]\), CreateDirectory[#]; 
                SetDirectory[#]] &, 
            listaNomi]; \[IndentingNewLine]SetDirectory[Last[listaNomi]]; \ 
          If[menuContent === "\<\>", CreateDirectory[ToFileName[{dir}]], 
            Export[ToFileName[{dir}], 
              menuContent, "\<Lines\>"]]];\)\)], "Input"],

Cell[BoxData[
    \(\(flattenStructure[nestedList_List, opts___?OptionQ] := 
        Module[{myDir, numSt, stp, structureCheck, findNull, 
            findLongFileNames, 
            struc}, \[IndentingNewLine]{myDir, numSt, 
              stp} = \({HomeFolder, NumberingStart, 
                  NumberingStep} /. {opts}\) /. Options[MakeGlossary]; 
          structureCheck = 
            Cases[nestedList, {a_String, _List, __} \[RuleDelayed] a, 
              Infinity]; 
          If[structureCheck =!= {}, 
            Print["\<The folders with the following names are not well \
formed: \>" <> ToString[structureCheck]]; 
            Abort[]]; \[IndentingNewLine]findNull = 
            Cases[nestedList, {a_String, {___, Null, ___}} \[RuleDelayed] a, 
              Infinity]; \[IndentingNewLine]If[findNull =!= {}, 
            Print["\<The folders with the following names contain a Null: \>" \
<> ToString[findNull]]; Abort[]]; 
          findLongFileNames = 
            Cases[nestedList, {a_String /; 
                    StringLength[a] > 28, _} \[RuleDelayed] a, 
              Infinity]; \[IndentingNewLine]If[findNull =!= {}, 
            Print["\<The following file names are too long: \>" <> 
                ToString[findLongFileNames]]; 
            Abort[]]; \[IndentingNewLine]struc = {{myDir, 
                  nestedList //. {a_String, {b_ /; 
                            Not[MatchQ[b, {"\<-***\>", "\<\>"}]], 
                          c___}} \[RuleDelayed] {a, {{"\<-***\>", "\<\>"}, b, 
                          c, {"\<-***\>", "\<\>"}}}} //. 
                addFolder[numSt, stp]}];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeGlossary[nestedList_List, opts___?OptionQ] := 
        Map[createFile, flattenStructure[nestedList, opts]];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Input palette", "Subtitle"],

Cell[BoxData[
    RowBox[{" ", GridBox[{
          {
            ButtonBox[\(#  insertion  #\)]},
          {
            ButtonBox[\(#  select  #\)]},
          {
            
            ButtonBox[\(#  selstart  #  \[SelectionPlaceholder]  #  
                selend  #\)]},
          {
            
            ButtonBox[\(\({"\<\[SelectionPlaceholder]\>", \
"\<\[Placeholder]\>"}\)\(,\)\)]},
          {
            
            ButtonBox[\(\({"\<\[SelectionPlaceholder]\>", \
\[IndentingNewLine]{{"\<\[Placeholder]\>", \
"\<\[Placeholder]\>"}}}\)\(,\)\)]},
          {
            
            ButtonBox[\(\[SelectionPlaceholder], \[IndentingNewLine]{"\<\
\[Placeholder]\>", "\<\[Placeholder]\>"}\)]},
          {
            ButtonBox[\(\({"\<-***\>", "\<\>"}\)\(,\)\)]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sample: BoxedEPS glossary", "Subtitle"],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell["The raw glossary data", "Subsubtitle"],

Cell[BoxData[
    \(\(boxedEPS = {"\<BoxedEPS\>", \
\[IndentingNewLine]{{"\<BoxedEPSF{select.eps}\>", \
"\<\\BoxedEPSF{#select##insertion#.eps}\>"}, {"\<BoxedEPSF{ scaled }\>", \
"\<\\BoxedEPSF{{#select##insertion#.eps scaled #insertion#}\>"}, \
{"\<tBoxedEPSF{select.eps}\>", "\<\\tBoxedEPSF{#select##insertion#.eps}\>"}, \
{"\<tBoxedEPSF{ scaled }\>", "\<\\tBoxedEPSF{{#select##insertion#.eps scaled \
#insertion#}\>"}, {"\<bBoxedEPSF{select.eps}\>", \
"\<\\bBoxedEPSF{#select##insertion#.eps}\>"}, {"\<bBoxedEPSF{ scaled }\>", \
"\<\\bBoxedEPSF{{#select##insertion#.eps scaled #insertion#}\>"}, \
{"\<cBoxedEPSF{select.eps}\>", "\<\\cBoxedEPSF{#select##insertion#.eps}\>"}, \
{"\<cBoxedEPSF{ scaled }\>", "\<\\cBoxedEPSF{{#select##insertion#.eps scaled \
#insertion#}\>"}, {"\<typical PlainTeX example\>", "\<\\input boxedeps.tex\n\
\\input boxedeps.cfg\n\\midinsert\n\\centerline{\\BoxedEPSF{gdisk.eps}}\n\
\\endinsert\n\\bye\>"}, \[IndentingNewLine]{"\<adjustments\>", \
\[IndentingNewLine]{{"\<Trim\>", \
\[IndentingNewLine]{{"\<TrimTop{percentage}\>", \
"\<#select#\\TrimTop{#selstart#percentage#selend##insertion#pct}\>"}, \
\[IndentingNewLine]{"\<TrimTop{dimen}\>", \
"\<#select#\\TrimTop{#selstart#dimen#selend##insertion#}\>"}, \
{"\<TrimLeft{percentage}\>", \
"\<#select#\\TrimLeft{#selstart#percentage#selend##insertion#pct}\>"}, \
{"\<TrimLeft{dimen}\>", \
"\<#select#\\TrimLeft{#selstart#dimen#selend##insertion#}\>"}, \
{"\<TrimBottom{percentage}\>", \
"\<#select#\\TrimBottom{#selstart#percentage#selend##insertion#pct}\>"}, \
{"\<TrimBottom{dimen}\>", \
"\<#select#\\TrimBottom{#selstart#dimen#selend##insertion#}\>"}, \
\[IndentingNewLine]{"\<TrimRight{percentage}\>", \
"\<#select#\\TrimRight{#selstart#percentage#selend##insertion#pct}\>"}, \
{"\<TrimRight{dimen}\>", \
"\<#select#\\TrimRight{#selstart#dimen#selend##insertion#}\>"}, \
\[IndentingNewLine]{"\<TrimBoundingBox{percentage}\>", \
"\<#select#\\TrimBoundingBox{#selstart#percentage#selend##insertion#pct}\>"}, \
\[IndentingNewLine]{"\<TrimBoundingBox{dimen}\>", \
"\<#select#\\TrimBoundingBox{#selstart#dimen#selend##insertion#pct}\>"}}}, {"\
\<slide\>", \[IndentingNewLine]{{"\<hSlide{dimen}\>", \
"\<#select#\\hSlide{#selstart#dimension#selend##insertion#}\>"}, \
{"\<vSlide{dimen}\>", \
"\<#select#\\vSlide{#selstart#dimension#selend##insertion#}\>"}}}, \
\[IndentingNewLine]{"\<force dimensions\>", \
\[IndentingNewLine]{{"\<ForceWidth{dimen}\>", \
"\<#select#\\ForceWidth{#selstart#dimension#selend##insertion#}\>"}, \
{"\<ForceHeight{dimen}\>", \
"\<#select#\\vSlide{#selstart#dimension#selend##insertion#}\>"}, \
{"\<EPSFxsize{dimen}\>", \
"\<#select#\\EPSFxsize{#selstart#dimension#selend##insertion#}\>"}, \
{"\<EPSFysize{dimen}\>", \
"\<#select#\\EPSFysize{#selstart#dimension#selend##insertion#}\>"}, \
\[IndentingNewLine]{"\<ForceOn\>", "\<#select#\\ForceOn#insertion#\>"}, \
\[IndentingNewLine]{"\<ForceOff\>", "\<#select#\\ForceOff#insertion#\>"}}}}}, \
\[IndentingNewLine]{"\<Options\>", \
\[IndentingNewLine]{{"\<ShowDisplacementBoxes (dflt)\>", \
"\<#select#\\ShowDisplacementBoxes#insertion#\>"}, \
{"\<HideDisplacementBoxes\>", \
"\<#select#\\HideDisplacementBoxes#insertion#\>"}, {"\<SetEPSFDirectory{}\>", \
"\<#select#\\SetEPSFDirectory{#selstart#directoryName#selend#}\>"}, \
\[IndentingNewLine]{"\<SetDefaultEPSFScale\>", \
"\<#select#\\SetDefaultEPSFScale{#selstart#scaleInMil#selend#}\>"}, \
\[IndentingNewLine]{"\<EmulateRokicki\>", \
"\<#select#\\EmulateRokicki#insertion#\>"}}}}};\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Some checks on the data", "Subsubtitle"],

Cell["How many glossary items:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Count[boxedEPS, {_, _String}, {1, Infinity}]\)], "Input"],

Cell[BoxData[
    \(3628\)], "Output"]
}, Open  ]],

Cell["Are there items exceeding the MacOS 9 filename limit?", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[
      boxedEPS, {a_String /; StringLength[a] > 28, __} \[RuleDelayed] a, {1, 
        Infinity}]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell["Are there items whose name contains the forbidden colon?", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[
      figureTablePicture, {a_String /; 
            StringMatchQ[a, "\<*:*\>"] > 28, __} \[RuleDelayed] a, {1, 
        Infinity}]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell["Are there Null entries?", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FreeQ[LaTeXmenu, Null]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["Find where those Null's are", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[
      LaTeXmenu, {a___, Null, b___} \[RuleDelayed] {a, Null, b}, {1, 
        Infinity}]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Build glossary", "Subsubtitle"],

Cell[BoxData[
    \(MakeGlossary[boxedEPS, 
        HomeFolder \[Rule] "\<MacintoshHD:Desktop Folder\>"] // 
      Short\)], "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 800}, {0, 580}},
WindowSize->{520, 458},
WindowMargins->{{Automatic, 55}, {46, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000ad2<?oYonl3<`920dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000008000
00000000004000000000000000000000\>"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 31, 0, 61, "Subtitle"],
Cell[1761, 54, 26, 0, 27, "Input"],
Cell[1790, 56, 42, 1, 27, "Input"],
Cell[1835, 59, 326, 6, 59, "Input"],
Cell[2164, 67, 524, 9, 123, "Input"],
Cell[2691, 78, 546, 10, 123, "Input"],
Cell[3240, 90, 540, 10, 123, "Input"],
Cell[3783, 102, 899, 17, 203, "Input"],
Cell[4685, 121, 952, 17, 235, "Input"],
Cell[5640, 140, 755, 14, 171, "Input"],
Cell[6398, 156, 1629, 29, 379, "Input"],
Cell[8030, 187, 148, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[8215, 194, 33, 0, 50, "Subtitle"],
Cell[8251, 196, 912, 28, 165, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9200, 229, 45, 0, 61, "Subtitle"],
Cell[9248, 231, 26, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[9299, 235, 44, 0, 53, "Subsubtitle"],
Cell[9346, 237, 3506, 60, 1499, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12889, 302, 46, 0, 42, "Subsubtitle"],
Cell[12938, 304, 40, 0, 30, "Text"],

Cell[CellGroupData[{
Cell[13003, 308, 77, 1, 27, "Input"],
Cell[13083, 311, 38, 1, 26, "Output"]
}, Open  ]],
Cell[13136, 315, 69, 0, 30, "Text"],

Cell[CellGroupData[{
Cell[13230, 319, 136, 3, 43, "Input"],
Cell[13369, 324, 36, 1, 26, "Output"]
}, Open  ]],
Cell[13420, 328, 72, 0, 30, "Text"],

Cell[CellGroupData[{
Cell[13517, 332, 170, 4, 59, "Input"],
Cell[13690, 338, 36, 1, 26, "Output"]
}, Open  ]],
Cell[13741, 342, 39, 0, 30, "Text"],

Cell[CellGroupData[{
Cell[13805, 346, 55, 1, 27, "Input"],
Cell[13863, 349, 38, 1, 26, "Output"]
}, Open  ]],
Cell[13916, 353, 43, 0, 30, "Text"],

Cell[CellGroupData[{
Cell[13984, 357, 128, 3, 43, "Input"],
Cell[14115, 362, 36, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[14200, 369, 37, 0, 42, "Subsubtitle"],
Cell[14240, 371, 133, 3, 59, "Input"]
}, Closed]]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

